﻿using CrowCanyon.DBServiceApp.Classes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace CrowCanyon.DBServiceApp
{
    public class DatabaseServiceController : ApiController
    {
        // GET api/<controller>
        public IEnumerable<string> Get()
        {
            return new string[] { "value1", "value2" };
        }

        // GET api/<controller>/5
        public string Get(int id)
        {
            return "value";
        }

        // POST api/<controller>
        public Dictionary<string, object> Post([FromBody]MethodInfo methodInfo)
        {
            Dictionary<string, object> result = new Dictionary<string, object>();
            try
            {
                switch (methodInfo.name.ToLower())
                {
                    case "selectquery":
                        return DBUtilsService.SelectQuery(methodInfo.parameters);
                    case "testconnection":
                        return DBUtilsService.TestConnection(methodInfo.parameters);
                    default:
                        result.Add("Error", string.Format("Method '{0}' not found.", methodInfo.name));
                        break;
                }

                result.Add("Result", "Success");
            }
            catch (Exception ex)
            {
                result.Add("Error", ex.ToString());
            }
            return result;
        }

        // PUT api/<controller>/5
        public void Put(int id, [FromBody]string value)
        {
        }

        // DELETE api/<controller>/5
        public void Delete(int id)
        {
        }
    }

    public class MethodInfo
    {
        public string name { get; set; }
        public Dictionary<string, object> parameters { get; set; }
    }
}